package com.hsbc.pgp.helper;

import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.util.encoders.Base64;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.util.List;


/**
 * <p>
 * TestPgpDecryption runs the decryption step using user inputted values.
 * It uses the {@link com.hsbc.pgp.helper.PgpHelper} class.
 * </p>
 */
public class TestPgpDecryption {

    /**
     * <p>
     * The main method runs decryption using the {@link com.hsbc.pgp.helper.PgpHelper}
     * The user should replace the empty String to the inputs with:
     * sandboxResponse: encoded response body from the sandbox api queried.
     * userKeyFilePath: path to the user's private key
     * bankKeyFilePath: path to the bank's public key
     * password: password/pathphrase for the keys
     * </p>
     *
     * @param args
     * @throws IOException
     */
    public static void main(String[] args) throws IOException {

        // responseBody from sandbox api.
        String sandboxResponse = "";

        String userKeyFilePath = ""; // path to the user's private key.

        String bankKeyFilePath = ""; // path to the bank's public key.

        String payloadFilePath = "";

        // password/passphrase for the keys
        String password = "";

        // END USER INPUTS //

        // Declare PGP helper instance.
        PgpHelper pgpHelper = new PgpHelper();

        // Declare input stream.
        BufferedInputStream dataStream = null;

        try (BufferedInputStream secretKey = new BufferedInputStream(new FileInputStream(userKeyFilePath)); BufferedInputStream bankKey = new BufferedInputStream(new FileInputStream(bankKeyFilePath)); ByteArrayOutputStream decryptedResult = new ByteArrayOutputStream()) {

            List<PGPPrivateKey> clientPrivateKeys = pgpHelper.fetchPrivateKeys(secretKey, password);

            // Get PGPPublicKey.
            List<PGPPublicKey> pgpPublicKeys = pgpHelper.readPublicKey(bankKey);

            // Decode the encrypted Payload
            //byte[] decodedPayload = Files.readAllBytes(Paths.get(pathToEncodedFile));
            byte[] decodedPayload = Base64.decode(sandboxResponse);

            // Convert decoded data to InputStream.
            dataStream = new BufferedInputStream(new ByteArrayInputStream(decodedPayload));

            // Decrypt the data.
            pgpHelper.decryptStream(dataStream, decryptedResult, clientPrivateKeys, pgpPublicKeys);

            // Convert decrypted data to String.
            payloadFilePath = decryptedResult.toString(StandardCharsets.UTF_8);

            System.out.println("Decrypted message:" + payloadFilePath);
            // END DECRYPTION //

        } catch (Exception ex) {
            System.out.println("**** Exception ****");
            System.out.println(ex.getMessage());
        } finally {
            if (dataStream != null) dataStream.close();
        }

    }
}
