package com.hsbc.pgp.helper;

import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.util.encoders.Base64;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;

/**
 * <p>
 * TestPgpEncryption runs the encryption step using user inputted values.
 * It uses the {@link com.hsbc.pgp.helper.PgpHelper} class.
 * </p>
 */
public class TestPgpEncryption {

    /**
     * <p>
     * The main method runs and encryption and decryption using the {@link com.hsbc.pgp.helper.PgpHelper}
     * The user should replace the empty String to the inputs with:
     * payload: path to the payload file
     * userKeyFilePath: path to the user's private key
     * bankKeyFilePath: path to the bank's public key
     * password: password/pathphrase for the keys
     * </p>
     *
     * @param args
     * @throws IOException
     */
    public static void main(String[] args) throws IOException {

        // BEGIN USER INPUTS //
        String payloadFilePath = ""; // path to the payload file.

        String userKeyFilePath = ""; // path to the user's private key.

        String bankKeyFilePath = ""; // path to the bank's public key.

        String password = ""; // password/passphrase for the keys.
        // END USER INPUTS //

        // Declare PGP helper instance.
        PgpHelper pgpHelper = new PgpHelper();

        // Declare output string.
        String encodedFile = "";

        // Declare input stream.
        BufferedInputStream dataStream = null;

        // Read in public key, private key and input data (to be encrypted) file.
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(); BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(payloadFilePath)); BufferedInputStream secretKey = new BufferedInputStream(new FileInputStream(userKeyFilePath)); BufferedInputStream bankKey = new BufferedInputStream(new FileInputStream(bankKeyFilePath));) {

            List<PGPPrivateKey> clientPrivateKeys = pgpHelper.fetchPrivateKeys(secretKey, password);

            // Get PGPPublicKey.
            List<PGPPublicKey> pgpPublicKeys = pgpHelper.readPublicKey(bankKey);

            // BEGIN ENCRYPTION //

            // Taking the outputStream, inputStream data and keys to encrypt the data.
            pgpHelper.encryptAndSign(outputStream, inputStream, pgpPublicKeys.get(0), clientPrivateKeys.get(0));

            // Encode in Base64 for sending to the treasury API.
            encodedFile = Base64.toBase64String(outputStream.toByteArray());

            // Print encrypted payload.
            System.out.println("Base64-encoded PGP message containing encrypted payload:\n" + encodedFile);

        } catch (Exception ex) {
            System.out.println("**** Exception ****");
            System.out.println(ex.getMessage());
        } finally {
            if (dataStream != null) dataStream.close();
        }
    }
}