package com.runner;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;

import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import config.KeyConfig;
import util.JsonUtil;
import util.PGPEncryptionExample;
import util.PGPExampleUtil;


public class BankSideEncryption {

	public BankSideEncryption() {
		
	}

		/**
		 * used to fix java.security.NoSuchProviderException: no such provider: BC
		 */
		static {
			try {
				Security.addProvider(new BouncyCastleProvider());
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		public static void main(String[] args) {
			BankSideEncryption encryption = new BankSideEncryption();
		    	try {
		    		encryption.encryptPayloadAndMakeToken();
				} catch (NoSuchProviderException e) {
					e.printStackTrace();
				} catch (NoSuchAlgorithmException e) {
					e.printStackTrace();
				} catch (IOException e) {
					e.printStackTrace();
				} catch (PGPException e) {
					e.printStackTrace();
				}
		  }

		public void encryptPayloadAndMakeToken()
				throws IOException, PGPException, NoSuchProviderException, NoSuchAlgorithmException {
			
			// Load bank response payload content
			JSONObject bankResponseJson = JsonUtil.getBankResponseJson();
			String bankResponsePayloadPlainString = JSON.toJSONString(bankResponseJson);
			System.out.println("Response Payload message: " + bankResponsePayloadPlainString);

			// Load Client PGP Public Key
			// This is required to create the Encrypted Payload - (Payload not to be signed
			// by HSBC Private Key)
			byte[] clientPublicKeybytes= JsonUtil.getKeyFromFile(KeyConfig.CLIENT_PUB_KEY.concat(".asc"));
			PGPPublicKey clientPgpPublicKey = PGPExampleUtil
					.readPublicKey(new String(clientPublicKeybytes));
			List<PGPPublicKey> pgpPublicKeys = new ArrayList<PGPPublicKey>();
			pgpPublicKeys.add(clientPgpPublicKey);
			String clientPublicKeyId = Long.toHexString(clientPgpPublicKey.getKeyID()).toUpperCase();

			System.out.println("client public key :" + KeyConfig.CLIENT_PUB_KEY + ". key : " + clientPublicKeyId);

			// encrypt Payload - Use only HSBC Public Key
			String bankResponsePayloadEncryptedBase64String = PGPEncryptionExample
					.encrpytRequestPayload(bankResponsePayloadPlainString, pgpPublicKeys, true, true, false);
			System.out.println("Bank Response payload encrypted Base64 String: " + bankResponsePayloadEncryptedBase64String);

		}

	}
