package com.runner;

import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Security;

import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;

import config.KeyConfig;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import util.JsonUtil;
import util.JwtSigningKeyResolver;
import util.PGPEncryptionExample;
import util.PGPExampleUtil;

public class BankSideTokenVNDecryption {

	public BankSideTokenVNDecryption() {
		
	}

	/**
	 * used to fix java.security.NoSuchProviderException: no such provider: BC
	 */
	static {
		try {
			Security.addProvider(new BouncyCastleProvider());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}


	public static void main(String[] args) {
		BankSideTokenVNDecryption bankTokenNdecrypt = new BankSideTokenVNDecryption();
	    bankTokenNdecrypt.decryptResponse();;
	  }
	
	public void decryptResponse() {

		try {
			// Load HSBC Private PGP Keys
			PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(
					PGPUtil.getDecoderStream(findFile(KeyConfig.HSBC_PRV_KEY.concat(".asc"))), new JcaKeyFingerprintCalculator());

			PGPSecretKey hsbcPgpSecretKey = PGPExampleUtil
					.readSecretKey(KeyConfig.CLIENT_KEY_PATH.concat(KeyConfig.HSBC_PRV_KEY).concat(".asc"));
			PGPPrivateKey hsbcPgpPrivateKey = PGPExampleUtil.findSecretKey(pgpSec, hsbcPgpSecretKey.getKeyID(),
					KeyConfig.HSBC_PRV_KEY_PWD.toCharArray());

			// Convert HSBC PGP Private key to RSA key
			PrivateKey hsbcPrivateKey = new JcaPGPKeyConverter().getPrivateKey(hsbcPgpPrivateKey);

			// request payload
			String encryptedClientRequestedPayload = JsonUtil.getEncryptedRequestedPayload();
			System.out.println("request message encrypted:" + encryptedClientRequestedPayload);
			
			//Verify JWT ?
			// Load the JWT from the file or string to be verified for signature
			String signedJWT = JsonUtil.getJwtForVerification();
			// Load customer PGP Public Key - (Why is it required at Client Side?)
			byte[] clientPublicKeybytes= JsonUtil.getKeyFromFile(KeyConfig.CLIENT_PUB_KEY.concat(".asc"));
			
			JwtParser parser = Jwts.parserBuilder().setSigningKeyResolver(
					new JwtSigningKeyResolver(new String(clientPublicKeybytes)))
					.build();
			
			try {
				System.out.println("######## TRYING TO PARSE JWT TOKEN STRING ########");
				parser.parse(signedJWT);
				System.out.println("######## SUCCESS ########");
			} catch (Exception e) {
				System.out.println("######## FAILURE ########");
				e.printStackTrace();
			}
			System.out.println("######## NOW DECRYPTING PAYLOAD ########");
			// Decrypt the request from Client
			String decryptedClientRequestString = PGPEncryptionExample.decryptResponseMessage(hsbcPgpPrivateKey,
					encryptedClientRequestedPayload);

			String decryptedClientRequestJson = jsonFormat(decryptedClientRequestString);
			System.out.println("response decrypt message:" + decryptedClientRequestJson);
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	public static InputStream findFile(final String file) {
		return BankSideTokenVNDecryption.class.getClassLoader().getResourceAsStream(file);
	}

	public static String jsonFormat(String jsonString) {
		JSONObject object = JSONObject.parseObject(jsonString);
		jsonString = JSON.toJSONString(object, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue,
				SerializerFeature.WriteDateUseDateFormat);
		return jsonString;
	}

}
