package com.runner;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.xml.bind.DatatypeConverter;

import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.util.encoders.Base64;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;

import config.KeyConfig;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import util.JsonUtil;
import util.PGPEncryptionExample;
import util.PGPExampleUtil;
import util.SampleClient;

public class ClientSideDecryption {

	public ClientSideDecryption() {


	}

	/**
	 * used to fix java.security.NoSuchProviderException: no such provider: BC
	 */
	static {
		try {
			Security.addProvider(new BouncyCastleProvider());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}


	public static void main(String[] args) {
		ClientSideDecryption clientSideDecryption = new ClientSideDecryption();
		clientSideDecryption.decryptResponse();
	}

	public void decryptResponse() {

		try {
			// Load Client Private PGP Keys
			PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(
					PGPUtil.getDecoderStream(findFile(KeyConfig.CLIENT_PRV_KEY.concat(".asc"))), new JcaKeyFingerprintCalculator());

			PGPSecretKey hsbcPgpSecretKey = PGPExampleUtil
					.readSecretKey(KeyConfig.CLIENT_KEY_PATH.concat(KeyConfig.CLIENT_PRV_KEY).concat(".asc"));
			PGPPrivateKey hsbcPgpPrivateKey = PGPExampleUtil.findSecretKey(pgpSec, hsbcPgpSecretKey.getKeyID(),
					KeyConfig.CLIENT_PRV_KEY_PWD.toCharArray());

			// Convert HSBC PGP Private key to RSA key
			PrivateKey hsbcPrivateKey = new JcaPGPKeyConverter().getPrivateKey(hsbcPgpPrivateKey);

			// request payload
			String bankResponseMessageEncrpytedString = JsonUtil.getEncryptedBankResponse();
			System.out.println("bank response message base64 encoded and encrypted :" + bankResponseMessageEncrpytedString);

			PGPEncryptionExample pex = new PGPEncryptionExample();
			System.out.println("######## DECRYPTING BANK RESPONSE PAYLOAD ########");
			// Decrypt the request from Client
			String bankResponseMessageDecryptedString = pex.decryptResponseMessage2(hsbcPgpPrivateKey, bankResponseMessageEncrpytedString);
			String bankResponseMessageDecrpytedJson = jsonFormat(bankResponseMessageDecryptedString);
			System.out.println("response decrypt message:" + bankResponseMessageDecrpytedJson);
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	public static InputStream findFile(final String file) {
		return SampleClient.class.getClassLoader().getResourceAsStream(file);
	}

	public static String jsonFormat(String jsonString) {
		JSONObject object = JSONObject.parseObject(jsonString);
		jsonString = JSON.toJSONString(object, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue,
				SerializerFeature.WriteDateUseDateFormat);
		return jsonString;
	}
}