package com.runner;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.xml.bind.DatatypeConverter;

import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;

import config.KeyConfig;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import util.JsonUtil;
import util.JwtJson;
import util.PGPEncryptionExample;
import util.PGPExampleUtil;
import util.SampleClient;

public class ClientSideTokenNEncryption {

	public ClientSideTokenNEncryption() {

	}

	/**
	 * used to fix java.security.NoSuchProviderException: no such provider: BC
	 */
	static {
		try {
			Security.addProvider(new BouncyCastleProvider());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void main(String[] args) {
	    	ClientSideTokenNEncryption clientTokenNEncrypt = new ClientSideTokenNEncryption();
	    	try {
				clientTokenNEncrypt.encryptPayloadAndMakeToken();
			} catch (NoSuchProviderException e) {
				e.printStackTrace();
			} catch (NoSuchAlgorithmException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} catch (PGPException e) {
				e.printStackTrace();
			}
	  }

	public void encryptPayloadAndMakeToken()
			throws IOException, PGPException, NoSuchProviderException, NoSuchAlgorithmException {
		// request payload
		JSONObject requestJson = JsonUtil.getRequestJson();
		String requestPayloadPlainString = JSON.toJSONString(requestJson);
		System.out.println("Payload message: " + requestPayloadPlainString);

		// Load Bank PGP Public Key
		// This is required to create the Encrypted Payload - (Payload not to be signed
		// by Client Private Key)
		PGPPublicKey hsbcPgpPublicKey = PGPExampleUtil
				.readPublicKey(KeyConfig.CLIENT_KEY_PATH.concat(KeyConfig.HSBC_PUB_KEY).concat(".asc"));
		List<PGPPublicKey> pgpPublicKeys = new ArrayList<PGPPublicKey>();
		pgpPublicKeys.add(hsbcPgpPublicKey);
		String hsbckeyId = Long.toHexString(hsbcPgpPublicKey.getKeyID()).toUpperCase();

		// Load customer PGP Public Key - (Why is it required at Client Side?)
		PGPPublicKey clientPgpPublicKey = PGPExampleUtil
				.readPublicKey(KeyConfig.CLIENT_KEY_PATH.concat(KeyConfig.CLIENT_PUB_KEY).concat(".asc"));
		String clientKeyId = Long.toHexString(clientPgpPublicKey.getKeyID()).toUpperCase();

		// Load customer Private PGP Keys
		PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(
				PGPUtil.getDecoderStream(findFile(KeyConfig.CLIENT_PRV_KEY.concat(".asc"))), new JcaKeyFingerprintCalculator());

		PGPSecretKey clientPgpSecretKey = PGPExampleUtil
				.readSecretKey(KeyConfig.CLIENT_KEY_PATH.concat(KeyConfig.CLIENT_PRV_KEY).concat(".asc"));
		PGPPrivateKey clientPgpPrivateKey = PGPExampleUtil.findSecretKey(pgpSec, clientPgpSecretKey.getKeyID(),
				KeyConfig.CLIENT_PRV_KEY_PWD.toCharArray());

		// Convert Client PGP Private key to RSA key
		PrivateKey clientPrivateKey = new JcaPGPKeyConverter().getPrivateKey(clientPgpPrivateKey);

		System.out.println("client public key :" + KeyConfig.CLIENT_PUB_KEY + ". key : " + clientKeyId);
		System.out.println("hsbc public key :" + KeyConfig.HSBC_PUB_KEY + ". key : " + hsbckeyId);

		// encrypt Payload - Use only HSBC Public Key
		String requestPayloadEncryptedBase64String = PGPEncryptionExample
				.encrpytRequestPayload(requestPayloadPlainString, pgpPublicKeys, true, true, false);
		System.out.println("request payload encrypted Base64 String: " + requestPayloadEncryptedBase64String);

		// create token - Use encrypted payload and Use client Private RSA key to sign
		String token = createToken(KeyConfig.PROFILE_ID, requestPayloadEncryptedBase64String, clientKeyId, clientPrivateKey);
		System.out.println("JWT Token: " + token);

	}

	/**
	 * createToken
	 *
	 * @param profileId                           profileId
	 * @param requestPayloadEncryptedBase64String requestPayloadEncryptedBase64String
	 * @param keyId                               keyId
	 * @param privateKey                          privateKey
	 * @return token
	 * @throws NoSuchAlgorithmException NoSuchAlgorithmException
	 * Chala - make changes here
	 */
	public static String createToken(String profileId, String requestPayloadEncryptedBase64String, String keyId,
			PrivateKey privateKey) throws NoSuchAlgorithmException {

		JwtJson jwtJson = JsonUtil.getJwtToCreateToken();
		
		String hashingAlgorithm = "SHA-256";
		String jwtId = UUID.randomUUID().toString();
		long nowSeconds = System.currentTimeMillis() / 1000;
		
		//Create claims and set available values from jwtJson
		Map<String, Object> claims = new HashMap<String, Object>();
		claims.put("sub", jwtJson.getSub());
		claims.put("aud", jwtJson.getAud());

		//now set generated values into the claims set as many of them are dynamic
		claims.put("iat", nowSeconds);
		claims.put("jti", jwtId);
		String payloadHash = generateMessageDigest(requestPayloadEncryptedBase64String, "SHA-256");
		claims.put("payload_hash", payloadHash);
		System.out.println("payload_hash:" + payloadHash);
		claims.put("payload_hash_alg", hashingAlgorithm);
		claims.put("obo", jwtJson.getObo());

		//do the same for header part, read available values from file and generate others
		Map<String, Object> header = new HashMap<String, Object>();
		header.put("typ", jwtJson.getTyp());
		header.put("alg", jwtJson.getAlg());
		
		header.put("kid", keyId);
		header.put("ver", jwtJson.getVer());

		//Create and sign token
		String token = Jwts.builder().setHeader(header).setClaims(claims).signWith(SignatureAlgorithm.RS256, privateKey)
				.compact();
		
		return token;
	}
	
	// Helper method for getting message digest
	private static String generateMessageDigest(String message, String hashingAlgorithm)
			throws NoSuchAlgorithmException {
		return DatatypeConverter.printHexBinary(MessageDigest.getInstance(hashingAlgorithm).digest(message.getBytes()))
				.toLowerCase();
	}

	public static InputStream findFile(final String file) {
		return SampleClient.class.getClassLoader().getResourceAsStream(file);
	}
	
	public static String jsonFormat(String jsonString) {
		JSONObject object = JSONObject.parseObject(jsonString);
		jsonString = JSON.toJSONString(object, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue,
				SerializerFeature.WriteDateUseDateFormat);
		return jsonString;
	}

}
