package util;


import com.alibaba.fastjson.JSONObject;
import config.ConfigInfo;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpStatus;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {

  /**
   * get request.
   *
   * @return
   */
  public static String doPost(String url, String params, String token, String profileId)
      throws Exception {
    HttpPost post = new HttpPost(url);
    RequestConfig config = RequestConfig.custom().build();
    post.setConfig(config);
    JSONObject jsonheader = getHeaders(token, profileId);
    for (Map.Entry<String, Object> entry : jsonheader.entrySet()) {
      post.setHeader(entry.getKey(), (String) entry.getValue());
    }
    post.setEntity(new StringEntity(params, "UTF-8"));
    SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy() {
      public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        return true;
      }
    }).build();
    SSLConnectionSocketFactory sslcsf = new SSLConnectionSocketFactory(sslContext,
        SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
    String resJson = null;
    try (CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory(sslcsf).build()) {
      CloseableHttpResponse response = client.execute(post);
      HttpEntity entity = response.getEntity();
      resJson = EntityUtils.toString(entity);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return resJson;
  }

  public static String doGet(String url, String token, String profileId) {
    String strResult = null;
    try {
      HttpGet requestGet = new HttpGet(url);
      JSONObject jsonheader = getHeaders(token, profileId);
      for (Map.Entry<String, Object> entry : jsonheader.entrySet()) {
        requestGet.setHeader(entry.getKey(), (String) entry.getValue());
      }
      CloseableHttpClient client = HttpClients.createDefault();
      CloseableHttpResponse response = client.execute(requestGet);
      HttpEntity httpEntity = response.getEntity();
      if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
        strResult = EntityUtils.toString(response.getEntity());
        System.out.println("response : " + strResult);
        return strResult;
      }
    } catch (IOException e) {
      e.printStackTrace();
    }
    return strResult;
  }

  public static String doGet(String url, String token) {
    return doGet(url, token, null);
  }

  public static JSONObject getHeaders(String token, String profileId) {
    JSONObject jsonheader = new JSONObject();
    jsonheader.put("Authorization", "JWS ".concat(token));
    jsonheader.put("Content-Type", "application/json");
    jsonheader.put("x-hsbc-profileId", profileId);
    jsonheader.put("requestId", "84e11e4935444951ae46177b6e78156c");
    jsonheader.put("countryCode", "CN");
    jsonheader.put("schemaVersion", "1.0");
    jsonheader.put("businessUnitCode", "CN01");
    return jsonheader;
  }
}
