package util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

import org.bouncycastle.util.encoders.Base64;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;

public class JsonUtil {

	public static final String RESOURCES_PATH = "request-content/";

	private JsonUtil() {
		super();
	}

	/**
	 * Read json response file.
	 *
	 * @return mock json data
	 */
	public static JSONObject getRequestJson() {
		StringBuilder sb = new StringBuilder();
		try (BufferedReader br = new BufferedReader(
				new InputStreamReader(new FileInputStream(getFile()), StandardCharsets.UTF_8))) {
			String line = null;
			while (null != (line = br.readLine())) {
				sb.append(line);
				sb.append("\r\n");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return JSON.parseObject(sb.toString());
	}

	public static String getFile() {
		String path = JsonUtil.class.getClassLoader().getResource(RESOURCES_PATH.concat("requestContent2.json"))
				.getPath();
		return path;
	}


	/**
	 * Read json response file.
	 *
	 * @return json response data
	 */
	public static JwtJson getJwtToCreateToken() {
		StringBuilder sb = new StringBuilder();
		JwtJson jwtObj = null;
		ObjectMapper mapper = new ObjectMapper();
		String p = JsonUtil.class.getClassLoader().getResource("jwtJson.json").getPath();
		try (BufferedReader br = new BufferedReader(
				new InputStreamReader(new FileInputStream(p), StandardCharsets.UTF_8))) {
				String line = null;
				while (null != (line = br.readLine())) {
					sb.append(line);
					sb.append("\r\n");
				}
			
			jwtObj = mapper.readValue(sb.toString(), JwtJson.class);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return jwtObj;
	}

	public static String getJwtForVerification() {
		StringBuilder sb = new StringBuilder();
		try (BufferedReader br = new BufferedReader(
				new InputStreamReader(new FileInputStream(getJwtToBeVerifiedFromFile()), StandardCharsets.UTF_8))) {
			String line = null;
			while (null != (line = br.readLine())) {
				sb.append(line);
				sb.append("\r\n");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return sb.toString();

	}

	private static String getJwtToBeVerifiedFromFile() {
		String path = JsonUtil.class.getClassLoader().getResource(RESOURCES_PATH.concat("jwtToBeVerified.json"))
				.getPath();
		return path;
	}
	
	
	
	public static String getEncryptedRequestedPayload() {
		StringBuilder sb = new StringBuilder();
		try (BufferedReader br = new BufferedReader(
				new InputStreamReader(new FileInputStream(getEncryptedRequestedPayloadFromFile()), StandardCharsets.UTF_8))) {
			String line = null;
			while (null != (line = br.readLine())) {
				sb.append(line);
				sb.append("\r\n");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return sb.toString();

	}

	private static String getEncryptedRequestedPayloadFromFile() {
		String path = JsonUtil.class.getClassLoader().getResource(RESOURCES_PATH.concat("encryptedClientRequest.json"))
				.getPath();
		return path;
	}
	
	public static byte[] getKeyFromFile(String fileName) {
		StringBuilder sb = new StringBuilder();
		try (BufferedReader br = new BufferedReader(
				new InputStreamReader(new FileInputStream(getKeyAsString(fileName)), StandardCharsets.UTF_8))) {
			String line = null;
			while (null != (line = br.readLine())) {
				sb.append(line);
				sb.append("\r\n");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return Base64.encode(sb.toString().getBytes());

	}

	private static String getKeyAsString(String keyFileName) {
		String path = JsonUtil.class.getClassLoader().getResource(keyFileName).getPath();
		return path;
	}

	/**
	 * Read json response file.
	 *
	 * @return mock json data
	 */
	public static JSONObject getBankResponseJson() {
		StringBuilder sb = new StringBuilder();
		try (BufferedReader br = new BufferedReader(
				new InputStreamReader(new FileInputStream(getBankResponseFile()), StandardCharsets.UTF_8))) {
			String line = null;
			while (null != (line = br.readLine())) {
				sb.append(line);
				sb.append("\r\n");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return JSON.parseObject(sb.toString());
	}

	public static String getBankResponseFile() {
		String path = JsonUtil.class.getClassLoader().getResource(RESOURCES_PATH.concat("bankResponsePlain.json"))
				.getPath();
		return path;
	}
	
	public static String getEncryptedBankResponse() {
		StringBuilder sb = new StringBuilder();
		try (BufferedReader br = new BufferedReader(
				new InputStreamReader(new FileInputStream(getEncryptedBankResponseFromFile()), StandardCharsets.UTF_8))) {
			String line = null;
			while (null != (line = br.readLine())) {
				sb.append(line);
				sb.append("\r\n");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return sb.toString();

	}

	private static String getEncryptedBankResponseFromFile() {
		String path = JsonUtil.class.getClassLoader().getResource(RESOURCES_PATH.concat("bankResponseEncrypted.json"))
				.getPath();
		return path;
	}

}
