package util;


import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.PublicKey;

import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.util.encoders.Base64;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.SigningKeyResolverAdapter;

public class JwtSigningKeyResolver extends SigningKeyResolverAdapter {
	
	private String clientPublicKey;
	
    @Override
    public Key resolveSigningKey(JwsHeader jwsHeader, Claims claims) {
        
        //inspect the header or claims, lookup and return the signing key
        
        String keyId = jwsHeader.getKeyId(); //or any other field that you need to inspect
        
        Key key = null;
		try {
			key = extractRSAKey(keyId);
		} catch (IOException e) {
			System.out.println("RSA key extraction error" + e.getMessage());
		} catch (PGPException e) {
			System.out.println("RSA key extraction error" + e.getMessage());
		} 
        
        return key;
    }
    
	public JwtSigningKeyResolver(String clientPublicKey) {
		super();
		this.clientPublicKey = clientPublicKey;
	}

	private PublicKey extractRSAKey(String keyId) throws IOException, PGPException {

		System.out.println("Got the Key with id  - "+keyId );
		System.out.println("Using this clientPublicKey  - "+ this.clientPublicKey );
		
		PGPPublicKeyRingCollection pgpPub = new PGPPublicKeyRingCollection(
				PGPUtil.getDecoderStream(new ByteArrayInputStream(Base64.decode(clientPublicKey.getBytes()))), new JcaKeyFingerprintCalculator());
		

		PGPPublicKey clientPgpPublicKey = pgpPub.getPublicKey(new BigInteger(keyId, 16).longValue());
		
		String clientPublicKeyId = Long.toHexString(clientPgpPublicKey.getKeyID()).toUpperCase();
		
		System.out.println("KeyID - "+keyId + "clientPublicKeyId - "+ clientPublicKeyId +" client public key :" + clientPgpPublicKey.toString());
		
		PublicKey clientPublicKeyRSA = new JcaPGPKeyConverter().getPublicKey(clientPgpPublicKey);
		

		return clientPublicKeyRSA;
	}
}
