package util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.io.IOUtils;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.Streams;

public class PGPEncryptionExample {

	public static String encrpytRequestPayload(String requestPayloadPlainString, List<PGPPublicKey> publicKeys, boolean armor,
                               boolean withIntegrityCheck, boolean isMasterKey) throws IOException, PGPException {
    ByteArrayOutputStream out = new ByteArrayOutputStream();
    OutputStream opOut;
    if (armor) {
      opOut = new ArmoredOutputStream(out);
    }else{
      opOut = out;
    }

    ByteArrayOutputStream byteArray = new ByteArrayOutputStream();

    InputStream inputStream = IOUtils.toInputStream(requestPayloadPlainString);

    PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
    OutputStream outputStream = literalDataGenerator.open(byteArray, PGPLiteralData.BINARY, PGPLiteralData.CONSOLE, inputStream.available(),
            new Date());
    Streams.pipeAll(inputStream, outputStream);
    outputStream.close();

    JcePGPDataEncryptorBuilder dataEncryptorBuilder = new JcePGPDataEncryptorBuilder(PGPEncryptedData.AES_256)
        .setWithIntegrityPacket(withIntegrityCheck).setSecureRandom(new SecureRandom())
        .setProvider("BC");

    PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator(dataEncryptorBuilder);
	PGPPublicKey encryptionKey = null;

    Iterator keyIter = publicKeys.iterator();
	while (keyIter.hasNext()){
		PGPPublicKey key = (PGPPublicKey) keyIter.next();
		if (key.isEncryptionKey() && (!key.isMasterKey() || isMasterKey)) {
			encryptionKey = key;
			}
		}
	if (encryptionKey == null) {
		throw new IllegalStateException("matching encrypted data not found");
		}
    JcePublicKeyKeyEncryptionMethodGenerator encryptionMethodGenerator =
      new JcePublicKeyKeyEncryptionMethodGenerator(encryptionKey)
          .setProvider("BC").setSecureRandom(new SecureRandom());
	
	encryptedDataGenerator.addMethod(encryptionMethodGenerator);
	
	byte[] bytes = byteArray.toByteArray();
	try (OutputStream dbOut = encryptedDataGenerator.open(opOut, bytes.length)) {
		dbOut.write(bytes);
		dbOut.close();
		opOut.close();

    return Base64.toBase64String(out.toByteArray());
    
	}
  }

	public static String decryptResponseMessage(PGPPrivateKey privateKey, String responseMessageEncryptedBase64String)
			throws PGPException, IOException {

		JcaKeyFingerprintCalculator keyFingerPrintCalculator = new JcaKeyFingerprintCalculator();

		String epicStrNew = new String(Base64.decode(responseMessageEncryptedBase64String));
		
		System.out.println("\n Base64 decoded bank response - " + epicStrNew);

		BufferedInputStream dataStream = new BufferedInputStream(IOUtils.toInputStream(epicStrNew));

		InputStream decoderStream = PGPUtil.getDecoderStream(dataStream);

		PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(decoderStream, keyFingerPrintCalculator);

		PGPEncryptedDataList pgpEncryptedDataList = (PGPEncryptedDataList) pgpObjectFactory.nextObject();

		// find the matching public key encrypted data packet.
		PGPPublicKeyEncryptedData pgpPublicKeyEncryptedData = null;

		// build decryptor factory
		PublicKeyDataDecryptorFactory dataDecryptorFactory = null;
		for (Object pgpEncData : pgpEncryptedDataList) {
			PGPPublicKeyEncryptedData pkEnc = (PGPPublicKeyEncryptedData) pgpEncData;
			//for (PGPPrivateKey privateKey : privateKeys) {
				if (pkEnc.getKeyID() == privateKey.getKeyID()) {
					pgpPublicKeyEncryptedData = pkEnc;
					dataDecryptorFactory = new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC")
							.build(privateKey);
					break;
				}
			//}
		}

		if (pgpPublicKeyEncryptedData == null || dataDecryptorFactory == null) {
			throw new IllegalStateException("matching encrypted data not found");
		}

		InputStream clear = pgpPublicKeyEncryptedData.getDataStream(dataDecryptorFactory);
//#4 Get the plain text by using your private key to decrypt the crypto text
		PGPObjectFactory plainFact = new PGPObjectFactory(clear, new JcaKeyFingerprintCalculator());
		Object message = plainFact.nextObject();

		ByteArrayOutputStream actualOutput = new ByteArrayOutputStream();
		Streams.pipeAll(((PGPLiteralData) message).getInputStream(), actualOutput);
		actualOutput.close();
		clear.close();
		// check data decrypts okay
		if (!pgpPublicKeyEncryptedData.verify()) {
			throw new RuntimeException("Enc data is invalid!");
		}
		return new String(actualOutput.toByteArray());
	}
	
	public String decryptResponseMessage2(PGPPrivateKey privateKey, String responseMessageEncryptedBase64String)
			throws PGPException, IOException {

		JcaKeyFingerprintCalculator keyFingerPrintCalculator = new JcaKeyFingerprintCalculator();

		String epicStrNew = new String(Base64.decode(responseMessageEncryptedBase64String));
		
		System.out.println("\n Base64 decoded bank response - " + epicStrNew);

		BufferedInputStream dataStream = new BufferedInputStream(IOUtils.toInputStream(epicStrNew));

		InputStream decoderStream = PGPUtil.getDecoderStream(dataStream);

		PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(decoderStream, keyFingerPrintCalculator);

		PGPEncryptedDataList pgpEncryptedDataList = (PGPEncryptedDataList) pgpObjectFactory.nextObject();

		// find the matching public key encrypted data packet.
		PGPPublicKeyEncryptedData pgpPublicKeyEncryptedData = null;

		// build decryptor factory
		PublicKeyDataDecryptorFactory dataDecryptorFactory = null;
		for (Object pgpEncData : pgpEncryptedDataList) {
			PGPPublicKeyEncryptedData pkEnc = (PGPPublicKeyEncryptedData) pgpEncData;
			//for (PGPPrivateKey privateKey : privateKeys) {
				if (pkEnc.getKeyID() == privateKey.getKeyID()) {
					pgpPublicKeyEncryptedData = pkEnc;
					dataDecryptorFactory = new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC")
							.build(privateKey);
					break;
				}
			//}
		}

		if (pgpPublicKeyEncryptedData == null || dataDecryptorFactory == null) {
			throw new IllegalStateException("matching encrypted data not found");
		}

		InputStream clear = pgpPublicKeyEncryptedData.getDataStream(dataDecryptorFactory);
//#4 Get the plain text by using your private key to decrypt the crypto text
		PGPObjectFactory plainFact = new PGPObjectFactory(clear, new JcaKeyFingerprintCalculator());
		Object message = plainFact.nextObject();

		ByteArrayOutputStream actualOutput = new ByteArrayOutputStream();
		Streams.pipeAll(((PGPLiteralData) message).getInputStream(), actualOutput);
		actualOutput.close();
		clear.close();
		// check data decrypts okay
		if (!pgpPublicKeyEncryptedData.verify()) {
			throw new RuntimeException("Enc data is invalid!");
		}
		return new String(actualOutput.toByteArray());
	}

}
