package util;
/*
 * ***************************************************************
 * , Copyright. HSBC Holdings plc ccyy ALL RIGHTS RESERVED.
 *
 * This software is only to be used for the purpose for which it
 * has been provided. No part of it is to be reproduced,
 * disassembled, transmitted, stored in a retrieval system or
 * translated in any human or computer language in any way or
 * for any other purposes whatsoever without the prior written
 * consent of HSBC Holdings plc.
 * ***************************************************************
 */

import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.xml.bind.DatatypeConverter;

import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;

import config.ConfigInfo;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;


public class SampleClient {


  public SampleClient() {

  }

  /**
   * used to fix java.security.NoSuchProviderException: no such provider: BC
   */
  static {
    try {
      Security.addProvider(new BouncyCastleProvider());
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * client keys
   */
  public static final String CLIENT_PUB_KEY = "PC000006017_tst_hk_pub";

  public static final String CLIENT_PRV_KEY = "PC000006017_tst_hk_prv";

  public static final String CLIENT_PRV_KEY_PWD = "mktuat00001";
  /**
   * subject (jwt sub)
   */
  public static final String PROFILE_ID = "PC000006017";
  /**
   * hsbc public key
   */
  public static final String HSBC_PUB_KEY = "hsbc_pub_key";
  /**
   * key path
   */
  public static final String CLIENT_KEY_PATH = "src/main/resources/";


  public static void main(String[] args) {
    try {
      //request payload
      JSONObject requestJson = JsonUtil.getRequestJson();
      String requestPayloadPlainString = JSON.toJSONString(requestJson);
      System.out.println("Payload message: " + requestPayloadPlainString);
      
      // Load Bank PGP Public Key
      // This is required to create the Encrypted Payload - (Payload not to be signed by Client Private Key)
      PGPPublicKey hsbcPgpPublicKey =
              PGPExampleUtil.readPublicKey(CLIENT_KEY_PATH.concat(HSBC_PUB_KEY).concat(".asc"));
          List<PGPPublicKey> pgpPublicKeys = new ArrayList<PGPPublicKey>();
          pgpPublicKeys.add(hsbcPgpPublicKey);
      String hsbckeyId = Long.toHexString(hsbcPgpPublicKey.getKeyID()).toUpperCase();          
      
      // Load customer PGP Public Key - (Why is it required at Client Side?)
      PGPPublicKey clientPgpPublicKey =
          PGPExampleUtil.readPublicKey(CLIENT_KEY_PATH.concat(CLIENT_PUB_KEY).concat(".asc"));
      String clientKeyId = Long.toHexString(clientPgpPublicKey.getKeyID()).toUpperCase();


      // Load customer Private PGP Keys
      PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(
          PGPUtil.getDecoderStream(findFile(CLIENT_PRV_KEY.concat(".asc"))),
          new JcaKeyFingerprintCalculator());

      PGPSecretKey clientPgpSecretKey =
          PGPExampleUtil.readSecretKey(CLIENT_KEY_PATH.concat(CLIENT_PRV_KEY).concat(".asc"));
      PGPPrivateKey clientPgpPrivateKey = PGPExampleUtil
          .findSecretKey(pgpSec, clientPgpSecretKey.getKeyID(), CLIENT_PRV_KEY_PWD.toCharArray());
      
      //Convert Client PGP Private key to RSA key
      PrivateKey clientPrivateKey = new JcaPGPKeyConverter().getPrivateKey(clientPgpPrivateKey);
     
      System.out.println("client public key :" + CLIENT_PUB_KEY + ". key : " + clientKeyId);
      System.out.println("hsbc public key :" + HSBC_PUB_KEY + ". key : " + hsbckeyId);

      //encrypt Payload - Use only HSBC Public Key
      String requestPayloadEncryptedBase64String =
          PGPEncryptionExample.encrpytRequestPayload(requestPayloadPlainString, pgpPublicKeys, true, true, false);
      System.out.println("request payload encrypted Base64 String: " + requestPayloadEncryptedBase64String);
      
      //create token - Use encrypted payload and Use client Private RSA key to sign
      String token = createToken(PROFILE_ID, requestPayloadEncryptedBase64String, clientKeyId, clientPrivateKey);
      System.out.println("JWT Token: " + token);
      
      //API call to HSBC/Sandbox
      String responseMessageEncrpytedString =
          HttpClientUtil.doPost(ConfigInfo.url, requestPayloadEncryptedBase64String, token, PROFILE_ID);
      
      /** Print response message and Print decrypted message */
      System.out.println("response message encrypted:" + responseMessageEncrpytedString);
      
      //Decrypt the response from HSBC
      String responseMessageDecryptedString = PGPEncryptionExample
          .decryptResponseMessage(clientPgpPrivateKey, responseMessageEncrpytedString);
      
      String responseMessageDecrpytedJson = jsonFormat(responseMessageDecryptedString);
      System.out.println("response decrypt message:" + responseMessageDecrpytedJson);
    } catch (Exception ex) {
      ex.printStackTrace();
    }
  }

  /**
   * createToken
   *
   * @param profileId      profileId
   * @param requestPayloadEncryptedBase64String requestPayloadEncryptedBase64String
   * @param keyId          keyId
   * @param privateKey     privateKey
   * @return token
   * @throws NoSuchAlgorithmException NoSuchAlgorithmException
   */
  public static String createToken(String profileId, String requestPayloadEncryptedBase64String, String keyId,
                                   PrivateKey privateKey) throws NoSuchAlgorithmException {

    String hashingAlgorithm = "RSASHA256";
    // Generate unique ID for this API call
    String jwtId = UUID.randomUUID().toString();
    // Build JWT
    long nowSeconds = System.currentTimeMillis() / 1000;
    Map<String, Object> claims = new HashMap<String, Object>();
    claims.put("sub", "0lDrptCNBziInvC79CNGPagZjsOFAabN");
    claims.put("iat", nowSeconds);
    claims.put("aud", "HSBC.MKT");
    //claims.put("jti", jwtId);
    String payloadHash = generateMessageDigest(requestPayloadEncryptedBase64String, "SHA-256");
    claims.put("payload_hash", payloadHash);
    System.out.println("payload_hash:" + payloadHash);
    claims.put("payload_hash_alg", hashingAlgorithm);

    Map<String, Object> header = new HashMap<String, Object>();
    header.put("typ", "JWT");
    header.put("kid", keyId);
    header.put("alg", SignatureAlgorithm.RS256.getValue());
    header.put("ver", "1.0");
    String token = Jwts.builder().setHeader(header)
        .setClaims(claims).signWith(SignatureAlgorithm.RS256, privateKey).compact();
    return token;
  }

  // Helper method for getting message digest
  private static String generateMessageDigest(String message, String hashingAlgorithm)
      throws NoSuchAlgorithmException {
    return DatatypeConverter
        .printHexBinary(MessageDigest.getInstance(hashingAlgorithm).digest(message.getBytes()))
        .toLowerCase();
  }


  public static InputStream findFile(final String file) {
    return SampleClient.class.getClassLoader().getResourceAsStream(file);
  }


  public static String jsonFormat(String jsonString) {
    JSONObject object = JSONObject.parseObject(jsonString);
    jsonString = JSON.toJSONString(object, SerializerFeature.PrettyFormat,
        SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat);
    return jsonString;
  }


}
