package api.wsit.product_request;

import org.apache.http.client.methods.HttpPost;

import api.wsit.product_request.execute.ApiSchema;

import java.util.HashMap;
import static api.wsit.product_request.execute.ApiRequestExecutor.execute;
import static api.wsit.product_request.execute.ApiSchema.ACTIVE_PROJECT_SETTINGS;
import static api.wsit.product_request.execute.ApiSchema.getRequestContentPath;

public class AccountInformation {

    public static final String API_PRODUCT_CATEGORY = "Account Information";
    public static final String API_FOLDER = "/account-information";
    
    
    

    public static class V3 extends ApiSchema.Edge {
        public static final String API_VERSION = "V3";

        public static class TransactionEnquiry {
            public static final String API_NAME = "Transaction Enquiry";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/TransactionEnquiry.json";
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "transactionsRequestBase64");
                    put("response", "reportBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "/v3/transactions");
                    put("UAT",  "");
                    put("PRODUCTION", "/cmb-connect-payments-pa-account-ts-cert-proxy/v3/transactions");

                }
            };
            public static HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>() {
                {
                    put("x-hsbc-client-id", ACTIVE_PROJECT_SETTINGS.get("clientProfileId"));
                    put("x-hsbc-client-secret", ACTIVE_PROJECT_SETTINGS.get("clientSecret"));
                    put("x-report-type", "JSON");
                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public TransactionEnquiry() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public static class EnquireAccountCustomerRelationship {
            public static final String API_NAME = "Transaction Enquiry";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/EnquireAccountCustomerRelationship.json";
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", null);
                    put("response", null);
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "/v1/sandbox-self-service/manage/data");
                    put("UAT",  "");
                    put("PRODUCTION", "/cmb-connect-payments-pa-account-ts-dev-proxy/v3/transactions");

                }
            };
            public static HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>() {
                {
                    put("x-hsbc-client-id", ACTIVE_PROJECT_SETTINGS.get("clientProfileId"));
                    put("x-hsbc-client-secret", ACTIVE_PROJECT_SETTINGS.get("clientSecret"));
                    put("x-hsbc-profile-id", ACTIVE_PROJECT_SETTINGS.get("organizationId"));
                    put("table-name", "baas_obo_profile");
                    put("product-category", "baas");
                    put("category-version", "1.0");
                    put("product-name", "account-information-v3");
                    put("api-name", "account-information");
                    put("api-version", "v3");
                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                    put("dataManagement", true);
                }
            };

            public EnquireAccountCustomerRelationship() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public static class EnquireInvoiceSummaryList {
            public static final String API_NAME = "Enquire Invoice Summary List";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/EnquireInvoiceSummaryList.json";
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("t", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "");
                    put("UAT",  "/cmb-gtrf-mkt-pa-scf-dev-external-proxy/v3/eb2b/supply-chain-finance/invoices/detail");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public EnquireInvoiceSummaryList() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }


    }
    public static class V2 extends ApiSchema.Edge {
        public static final String API_VERSION = "V2";

        public static class TransactionEnquiry {
            public static final String API_NAME = "Transaction Enquiry";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/TransactionEnquiry.json";
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "transactionsRequestBase64");
                    put("response", "reportBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "/v2/transactions");
                    put("UAT",  "");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>() {
                {
                    put("x-hsbc-profile-id", ACTIVE_PROJECT_SETTINGS.get("organizationId"));
                    put("x-hsbc-client-id", ACTIVE_PROJECT_SETTINGS.get("clientProfileId"));
                    put("x-hsbc-client-secret", ACTIVE_PROJECT_SETTINGS.get("clientSecret"));
                    put("x-report-type", "JSON");
                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public TransactionEnquiry() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public static class EnquireInvoiceSummaryList {
            public static final String API_NAME = "Enquire Invoice Summary List";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/EnquireInvoiceSummaryList.json";
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "transactionsRequestBase64");
                    put("response", "transactionsResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "");
                    put("UAT",  "/cmb-gtrf-mkt-pa-scf-dev-external-proxy/v3/eb2b/supply-chain-finance/invoices/detail");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public EnquireInvoiceSummaryList() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }


    }

}
