package api.wsit.product_request;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;

import java.io.FileInputStream;
import java.util.HashMap;

import static api.wsit.product_request.execute.ApiRequestExecutor.execute;
import static api.wsit.product_request.execute.ApiSchema.*;

public class Common {

    public static final String API_PRODUCT_CATEGORY = "Common Utility";
    public static final String API_FOLDER = "/common";

    public static class V3 extends Edge {
        public static final String API_VERSION = "V3";

        public static class SubmitDocuments {
            public static final String API_NAME = "Submit Documents";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> REQUEST_JSON_FILE = new HashMap<String,String>() {
                {
                    put("file001", getRequestContentPath(API_FOLDER, API_VERSION) + "/file001.txt");
                    put("file002", getRequestContentPath(API_FOLDER, API_VERSION) + "/file002.txt");
                }
            };
            public static final HashMap<String, String> FILES_TO_UPLOAD = new HashMap<String,String>() {
                {
                    put("file001", getRequestContentPath(API_FOLDER, API_VERSION) + "/file001.txt");
                    put("file002", getRequestContentPath(API_FOLDER, API_VERSION) + "/file002.txt");
                }
            };
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "");
                    put("UAT",  "/cmb-gtrf-mkt-pa-scf-dev-external-proxy/v3/supply-chain-finance/supplier-onboarding-applications");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitDocuments() {
            }

            public static void main(String[] args) {
                try {
                   /* byte[] bytes;
                    for (HashMap.Entry<String, String> entry : FILES_TO_UPLOAD.entrySet()) {
                        bytes = AesCipherFile.multStreamMessageDigest(new FileInputStream(entry.getValue()));
                        System.out.println("    " + entry.getKey() + ":" + entry.getValue());
                    }
                    execute(API_SETTINGS);*/
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }



    }

}
