package api.wsit.product_request;

import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import api.wsit.product_request.execute.ApiSchema;
import org.json.JSONObject;

import java.util.HashMap;
import static api.wsit.product_request.execute.ApiRequestExecutor.execute;
import static api.wsit.product_request.execute.ApiSchema.getRequestContentPath;

public class SellerLoans {

    public static final String API_PRODUCT_CATEGORY = "Seller Loans";
    public static final String API_FOLDER = "/seller-loans";

    public static class V3 extends ApiSchema.Edge {
        public static final String API_VERSION = "V3";

        public static class SubmitStandardSellerLoanApplications {
            public static final String API_NAME = "Submit Standard Seller Loan Applications";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap<String, String> TRADE_ACCOUNT = new HashMap<String, String>() {
                {
                    put("accountCountry", "HK");
                    put("institutionCode",  "HSBC");
                    put("accountNumber", "181014200095");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>() {
                {
                    put("claims", new HashMap<String, Object>());
                    put("claimsToEncrypt", new HashMap<String, Object>(){
                        {
                            put("tradeAccounts", new JSONObject(TRADE_ACCOUNT));
                        }
                    });
                }
            };
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/SubmitStandardSellerLoanApplications.json";

            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT",  "/cmb-gtrf-mkt-ea-loans-uat-external-proxy/v3/trade-loans/seller/standard/applications");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitStandardSellerLoanApplications() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class SubmitAdvancedSellerLoanApplications {
            public static final String API_NAME = "Submit Advanced Seller Loan Applications";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap<String, String> TRADE_ACCOUNT = new HashMap<String, String>() {
                {
                    put("accountCountry", "HK");
                    put("institutionCode",  "HSBC");
                    put("accountNumber", "181014200095");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>() {
                {
                    put("claims", new HashMap<String, Object>());
                    put("claimsToEncrypt", new HashMap<String, Object>(){
                        {
                            put("tradeAccounts", new JSONObject(TRADE_ACCOUNT));
                        }
                    });
                }
            };
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/SubmitAdvancedSellerLoanApplications.json";

            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT",  "/cmb-gtrf-mkt-ea-loans-uat-external-proxy/v3/trade-loans/seller/advanced/applications");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitAdvancedSellerLoanApplications() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public static class SubmitSellerLoanExtensions {
            public static final String API_NAME = "Submit Seller Loan Extensions";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap<String, String> TRADE_ACCOUNT = new HashMap<String, String>() {
                {
                    put("accountCountry", "HK");
                    put("institutionCode",  "HSBC");
                    put("accountNumber", "181014200095");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>() {
                {
                    put("claims", new HashMap<String, Object>());
                    put("claimsToEncrypt", new HashMap<String, Object>(){
                        {
                            put("tradeAccounts", new JSONObject(TRADE_ACCOUNT));
                        }
                    });
                }
            };
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/SubmitSellerLoanExtensions.json";

            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT",  "/cmb-gtrf-mkt-ea-loans-uat-external-proxy/v3/trade-loans/extension-applications");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitSellerLoanExtensions() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class SubmitSellerLoanSettlements {
            public static final String API_NAME = "Submit Seller Loan Settlements";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap<String, String> TRADE_ACCOUNT = new HashMap<String, String>() {
                {
                    put("accountCountry", "HK");
                    put("institutionCode",  "HSBC");
                    put("accountNumber", "181014200095 ");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>() {
                {
                    put("claims", new HashMap<String, Object>());
                    put("claimsToEncrypt", new HashMap<String, Object>(){
                        {
                            put("tradeAccounts", new JSONObject(TRADE_ACCOUNT));
                        }
                    });
                }
            };
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/SubmitSellerLoanSettlements.json";

            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT",  "/cmb-gtrf-mkt-ea-loans-uat-external-proxy/v3/trade-loans/settlement-applications");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitSellerLoanSettlements() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class EnquireSellerLoanStatusSummary {
            public static final String API_NAME = "Enquire Seller Loan Status Summary";
            public static final String HTTP_METHOD = HttpGet.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>() {
                {
                    put("pageNumber", "1");
                    put("pageSize", "10");
                    //put("loanNumber", "");
                    //put("customerReference","");
                    //put("status","");
                    //put("beneficiaryName","");
                }
            };
            public static HashMap<String, String> TRADE_ACCOUNT = new HashMap<String, String>() {
                {
                    put("accountCountry", "HK");
                    put("institutionCode",  "HSBC");
                    put("accountNumber", "181014200095 ");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>() {
                {
                    put("claims", new HashMap<String, Object>());
                    put("claimsToEncrypt", new HashMap<String, Object>(){
                        {
                            put("tradeAccounts", new JSONObject(TRADE_ACCOUNT));
                        }
                    });
                }
            };
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/EnquireSellerLoanStatusSummary.json";

            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT",  "/cmb-gtrf-mkt-ea-loans-uat-external-proxy/v3/trade-loans");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public EnquireSellerLoanStatusSummary() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class EnquireSellerLoanDetail {
            public static final String API_NAME = "Enquire Seller Loan Detail";
            public static final String HTTP_METHOD = HttpGet.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>() {
                {
                    put("loanNumber", "LAEHKH132007");
                    //put("applicationId", "")
                }
            };
            public static HashMap<String, String> TRADE_ACCOUNT = new HashMap<String, String>() {
                {
                    put("accountCountry", "HK");
                    put("institutionCode",  "HSBC");
                    put("accountNumber", "181014200095 ");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>() {
                {
                    put("claims", new HashMap<String, Object>());
                    put("claimsToEncrypt", new HashMap<String, Object>(){
                        {
                            put("tradeAccounts", new JSONObject(TRADE_ACCOUNT));
                        }
                    });
                }
            };
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/EnquireSellerLoanDetail.json";

            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", null);
                    put("UAT",  "/cmb-gtrf-mkt-ea-loans-uat-external-proxy/v3/trade-loans/details");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public EnquireSellerLoanDetail() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

    }



    public static class V1 extends ApiSchema.Gtrf {
        public static final String API_VERSION = "V1";

        public static class SubmitSellerLoanApplications {
            public static final String API_NAME = "Submit Seller Loan Applications";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/SubmitSellerLoanApplications.json";
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", null);
                    put("response", null);
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "/trade-finance/v1/seller-loans/standard");
                    put("UAT",  "/cmb-gtrf-mkt-pa-tradeloan-uat-external-proxy/v1/eb2b/seller-loans/standard");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitSellerLoanApplications() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class SubmitAdvancedSellerLoanApplications {
            public static final String API_NAME = "Submit Advanced Seller Loan Applications";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/SubmitAdvancedSellerLoanApplications.json";
            
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", null);
                    put("response", null);
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "/trade-finance/v1/seller-loans/advanced");
                    put("UAT",  "/cmb-gtrf-mkt-pa-tradeloan-uat-external-proxy/v1/eb2b/seller-loans/advanced");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitAdvancedSellerLoanApplications() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class SubmitSellerLoanExtensions {
            public static final String API_NAME = "Submit Seller Loan Extensions";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/SubmitSellerLoanExtensions.json";
            
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", null);
                    put("response", null);
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "/trade-finance/v1/seller-loans/standard/extension");
                    put("UAT", "/cmb-gtrf-mkt-pa-tradeloan-uat-external-proxy/v1/eb2b/seller-loans/standard/extension");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitSellerLoanExtensions() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class SubmitSellerLoanSettlements {
            public static final String API_NAME = "Submit Seller Loan Settlements";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/SubmitSellerLoanSettlements.json";
            
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", null);
                    put("response", null);
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "/trade-finance/v1/seller-loans/standard/settlement");
                    put("UAT", "/cmb-gtrf-mkt-pa-tradeloan-uat-external-proxy/v1/eb2b/seller-loans/standard/settlement");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitSellerLoanSettlements() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class EnquireSellerLoanStatusSummary {
            public static final String API_NAME = "Enquire Seller Loan Status Summary";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/EnquireSellerLoanStatusSummary.json";
            
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", null);
                    put("response", null);
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "/trade-finance/v1/trade-loans/list");
                    put("UAT", "/cmb-gtrf-mkt-pa-tradeloan-uat-external-proxy/v1/eb2b/trade-loans/list");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public EnquireSellerLoanStatusSummary() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        public static class EnquireSellerLoanDetail {
            public static final String API_NAME = "Enquire Seller Loan Detail";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/EnquireSellerLoanDetail.json";
            
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", null);
                    put("response", null);
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "/trade-finance/v1/trade-loans/detail");
                    put("UAT", "/cmb-gtrf-mkt-pa-tradeloan-uat-external-proxy/v1/eb2b/trade-loans/detail");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public EnquireSellerLoanDetail() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

