package api.wsit.product_request;

import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import api.wsit.product_request.execute.ApiSchema;
import org.apache.http.entity.ContentType;
import org.json.JSONObject;

import java.util.HashMap;
import static api.wsit.product_request.execute.ApiRequestExecutor.execute;
import static api.wsit.product_request.execute.ApiSchema.*;

public class SupplyChainFinance {

    public static final String API_PRODUCT_CATEGORY = "Supply Chain Finance";
    public static final String API_FOLDER = "/supply-chain-finance";
    public static final HashMap<String, String> CHANNELS = new HashMap<String, String>() {
        {
            put("CN", "HBAP");
            put("HK", "HBAP");
            put("GB", "NRFB");
        }
    };

    public static class V3 extends ApiSchema.Edge {
        public static final String API_VERSION = "V3";

        public static class SubmitSupplierOnBoardingApplications {
            public static final String API_NAME = "Submit Supplier On-boarding Applications";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/SubmitSupplierOnBoardingApplications.json";
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "");
                    put("UAT",  "/cmb-gtrf-mkt-pa-scf-dev-external-proxy/v3/supply-chain-finance/supplier-onboarding-applications");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitSupplierOnBoardingApplications() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public static class EnquireSupplierOnBoardingApplicationStatus {
            public static final String API_NAME = "Enquire Supplier On-boarding Application Status";
            public static final String HTTP_METHOD = HttpGet.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>() {
                {
                    put("buyerCode", "BUY02");
                    put("pageSize", "10");
                    put("pageNumber", "1");
                    //put("supplierCode", "");
                    //put("requestSerialNumber", "");
                    //put("requestedExecutionDate", "");
                    //put("status", "");
                    //put("startDate", "");
                    //put("endDate", "");
                }

            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>();
            public static final String REQUEST_JSON_FILE = null;
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "");
                    put("UAT",  "/cmb-gtrf-mkt-pa-scf-dev-external-proxy/v3/supply-chain-finance/supplier-onboarding");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public EnquireSupplierOnBoardingApplicationStatus() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public static class SubmitApprovedInvoices {
            public static final String API_NAME = "Submit Approved Invoices";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/SubmitApprovedInvoices.json";
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "");
                    put("UAT",  "/cmb-gtrf-mkt-ea-scf-uat-external-proxy/v3/approved-invoices");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>() {
                {
                    put("X-HSBC-Chnl-Group-Member", "");
                }
            };
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitApprovedInvoices() {
            }

            public static void main(String[] args) {
                try {
                    String clientHostingRegion = ACTIVE_PROJECT_SETTINGS.get("clientHostingRegion");
                    switch (clientHostingRegion) {
                        case ("CN"):
                        case ("HK"):
                        case ("GB"):
                            ADDITIONAL_REQUEST_HEADERS.put("X-HSBC-Chnl-Group-Member", CHANNELS.get(clientHostingRegion));
                            API_SETTINGS.put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);

                    }
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public static class EnquireInvoiceSummaryList {
            public static final String API_NAME = "Enquire Invoice Summary List";
            public static final String HTTP_METHOD = HttpGet.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>() {
                {
                    put("buyerCode", "TESTBUY003");
                    put("pageSize", "10");
                    put("pageNumber", "1");
                    //put("fileId", "439731d5fcf149e28a3d44a9f9e1df99");
                    //put("endToEndIdentification", "FF-250624-000038");
                    //put("requestedExecutionDate", "");
                    //put("invoiceNumber", "bd335573c35c4a93be55056dec02d7a9");
                    //put("startDate", "");
                    //put("endDate", "");
                }
            };
            public static HashMap<String, Object> ADDITIONAL_TOKEN_CLAIMS = new HashMap<String, Object>();
            public static final String REQUEST_JSON_FILE = null;
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", "encryptedRequestBase64");
                    put("response", "encryptedResponseBase64");
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "");
                    put("UAT",  "/cmb-gtrf-mkt-ea-scf-uat-external-proxy/v3/approved-invoices");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("additionalTokenClaims",ADDITIONAL_TOKEN_CLAIMS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public EnquireInvoiceSummaryList() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }


    }

    public static class V1 extends ApiSchema.Gtrf {
        public static final String API_VERSION = "V1";

        public static class SubmitApprovedInvoices {
            public static final String API_NAME = "Submit Approved Invoices";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/SubmitApprovedInvoices.json";
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", null);
                    put("response", null);
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "/trade-finance/v1/supply-chain-finance/invoices");
                    put("UAT", "");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public SubmitApprovedInvoices() {
            }

            public static void main(String[] args) {
                try {
                    String clientHostingRegion = ACTIVE_PROJECT_SETTINGS.get("clientHostingRegion");
                    switch (clientHostingRegion) {
                        case ("CN"):
                        case ("HK"):
                        case ("GB"):
                            ADDITIONAL_REQUEST_HEADERS.put("institutionCode", CHANNELS.get(clientHostingRegion));
                            API_SETTINGS.put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);

                    }
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public static class EnquireInvoiceSummaryList {
            public static final String API_NAME = "Enquire Invoice Summary List";
            public static final String HTTP_METHOD = HttpPost.METHOD_NAME;
            public static final HashMap<String, String> REQUEST_URI_PARAMETERS = new HashMap<String, String>();
            public static final String REQUEST_JSON_FILE = getRequestContentPath(API_FOLDER, API_VERSION) + "/EnquireInvoiceSummaryList.json";
            public static final HashMap<String, String> PAYLOAD_WRAPPERS = new HashMap<String, String>() {
                {
                    put("request", null);
                    put("response", null);
                }
            };
            public static final HashMap<String, String> API_ENDPOINT_URLS = new HashMap<String, String>() {
                {
                    put("SANDBOX", "/trade-finance/v1/supply-chain-finance/invoices/detail");
                    put("UAT", "");
                    put("PRODUCTION", "");

                }
            };
            public static HashMap<String, String> ADDITIONAL_REQUEST_HEADERS = new HashMap<String, String>();
            public static HashMap API_SETTINGS = new HashMap<String, Object>() {
                {
                    put("apiProductCategory", API_PRODUCT_CATEGORY);
                    put("apiVersion", API_VERSION);
                    put("apiName", API_NAME);
                    put("httpMethod", HTTP_METHOD);
                    put("apiEndpointUrls", API_ENDPOINT_URLS);
                    put("apiSchema", SCHEMA_NAME);
                    put("requestUriParameters", REQUEST_URI_PARAMETERS);
                    put("contentType", CONTENT_TYPE);
                    put("additionalRequestHeaders", ADDITIONAL_REQUEST_HEADERS);
                    put("requestJsonFile", REQUEST_JSON_FILE);
                    put("xHsbcCryptoSignature", X_HSBC_CRYPTO_SIGNATURE);
                    put("payloadWrappers", PAYLOAD_WRAPPERS);
                }
            };

            public EnquireInvoiceSummaryList() {
            }

            public static void main(String[] args) {
                try {
                    execute(API_SETTINGS);
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }


    }

}
