package api.wsit.product_request.execute;

import config.ClientConfig;
import org.apache.http.entity.ContentType;
import util.Projects;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.UUID;

public class ApiSchema {
    private static String REQUEST_CONTENT_PATH;
    private static String CONTENT_TYPE;
    public static final HashMap<String, String> ACTIVE_PROJECT_SETTINGS = Projects.LoadActiveProjectSettings();

    public ApiSchema() {
    }
    public static final String getRequestContentPath(String apiFolder, String version){
        REQUEST_CONTENT_PATH = ClientConfig.REQUEST_CONTENT_PATH + apiFolder + "/" + version;
        return REQUEST_CONTENT_PATH;
    }
    public static final String getRequestContentType(String clientHostingRegion){
        if (clientHostingRegion == "CN") {
            CONTENT_TYPE = ContentType.TEXT_PLAIN.getMimeType();
        }
        else {
            CONTENT_TYPE = ContentType.APPLICATION_JSON.getMimeType();
        }
        return CONTENT_TYPE;
    }

    public static class Edge {
        ApiSchema apiSchema;
        public static final String SCHEMA_NAME = "EDGE";
        public static final String CONTENT_TYPE = ContentType.APPLICATION_JSON.getMimeType();
        public static final Boolean X_HSBC_CRYPTO_SIGNATURE = Boolean.valueOf(ACTIVE_PROJECT_SETTINGS.get("xHsbcCryptoSignature"));
        public Edge(){}

    }
    public static class Gtrf {
        ApiSchema apiSchema;
        public static final String SCHEMA_NAME = "GTRF";
        public static String CONTENT_TYPE = getRequestContentType(ACTIVE_PROJECT_SETTINGS.get("clientHostingRegion"));
        public static final Boolean X_HSBC_CRYPTO_SIGNATURE = false;
        public Gtrf(){}
    }
}
