package config;

import io.jsonwebtoken.SignatureAlgorithm;

import java.util.HashMap;

public class ClientConfig {
    public static final String RESOURCE_PATH = "src/main/resources/";
    public static final String REQUEST_CONTENT_PATH = RESOURCE_PATH + "request-json-file/wsit";
    public static final String KEY_PATH = RESOURCE_PATH + "keys/";
    public static final HashMap<String, String> BASE_URL = new HashMap<String, String>() {
        {
            put("SANDBOX", "https://sandbox.corporate-api.hsbc.com");
            put("UAT", "https://wsit-dev-api.hsbc.co.uk");
            put("PRODUCTION", "https://devcluster.api.p2g.netd2.hsbc.com.hk");
        }
    };


    /**
     * Step 1.0 - Configure proxy mode
     * String proxyMode = 0 if your connection does not need to pass-through proxy.
     * String proxyMode = 1 if your need to pass-through proxy.
     * String proxyMode = 2 if your need to enable proxy authentication.
     */
    public static final int proxyMode = 1;

    /**
     * Step 1.1 - Configure Basic Proxy Information
     * Input proxyHost and proxyPort if you have set proxyMode = 1 or 2 in step 1.0
     */
    public static final String proxyHost = "uk-proxy-01.systems.uk.hsbc";
    public static final int proxyPort = 8080;

    /**
     * Step 1.2 - Configure Proxy Authentication Information
     * Input proxyUser and proxyPassword you have set proxyMode = 2 in Step 1.0
     */
    public static final String proxyUser = "";
    public static final String proxyPassword = "";
    /**
     * JSON Web Token
     */
    public static final SignatureAlgorithm SIGNATURE_ALG = SignatureAlgorithm.PS256;
    public static final String TOKEN_ALG = SIGNATURE_ALG.toString();
    public static final String TOKEN_PAYLOAD_HASH_ALG = "SHA-256"; //Your Request Payload Hashing Algorithm

}
