package util;

import config.ProjectResource;
import org.bouncycastle.util.encoders.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class JsonUtil {


    private JsonUtil() {
        super();
    }

    /**
     * Read mock json file.
     *
     * @return mock json data
     */

    public static JSONObject getJsonObjectFromFile(String fileName) {
        StringBuilder sb = new StringBuilder();
        JSONObject requestJson = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(
                new FileInputStream(fileName),
                StandardCharsets.UTF_8))) {
            String line = null;
            while (null != (line = br.readLine())) {
                sb.append(line);
                sb.append("\r\n");
            }
            requestJson = new JSONObject(sb.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return requestJson;
    }

    public static String getStringFromFile(String fileName) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(
                new FileInputStream(fileName),
                StandardCharsets.UTF_8))) {
            String line = null;
            while (null != (line = br.readLine())) {
                sb.append(line);
                sb.append("\r\n");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static boolean isValidJson(String test) {
        try {
            new JSONObject(test);
        } catch (JSONException ex) {
            // edited, to include @Arthur's comment
            // e.g. in case JSONArray is valid as well...
            try {
                new JSONArray(test);
            } catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }


    /**
     * Read json response file.
     *
     * @return json response data
     */
/*	public static JwtJson getJwtToCreateToken() {
		StringBuilder sb = new StringBuilder();
		JwtJson jwtObj = null;
		ObjectMapper mapper = new ObjectMapper();
		String p = JsonUtil.class.getClassLoader().getResource("jwtJson.json").getPath();
		try (BufferedReader br = new BufferedReader(
				new InputStreamReader(new FileInputStream(p), StandardCharsets.UTF_8))) {
				String line = null;
				while (null != (line = br.readLine())) {
					sb.append(line);
					sb.append("\r\n");
				}

			jwtObj = mapper.readValue(sb.toString(), JwtJson.class);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return jwtObj;
	}

 */

/*	public static String getJwtForVerification() {
		StringBuilder sb = new StringBuilder();
		try (BufferedReader br = new BufferedReader(
				new InputStreamReader(new FileInputStream(getJwtToBeVerifiedFromFile()), StandardCharsets.UTF_8))) {
			String line = null;
			while (null != (line = br.readLine())) {
				sb.append(line);
				sb.append("\r\n");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return sb.toString();

	}

	private static String getJwtToBeVerifiedFromFile() {
		String path = JsonUtil.class.getClassLoader().getResource(HostConfig.RESPONSE_CONTENT_PATH.concat("jwtToBeVerified.json"))
				.getPath();
		return path;
	}

*/
    public static String getEncryptedRequestedPayload() {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(
                new InputStreamReader(new FileInputStream(getEncryptedRequestedPayloadFromFile()), StandardCharsets.UTF_8))) {
            String line = null;
            while (null != (line = br.readLine())) {
                sb.append(line);
                sb.append("\r\n");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();

    }

    private static String getEncryptedRequestedPayloadFromFile() {
        String path = JsonUtil.class.getClassLoader().getResource(ProjectResource.RESPONSE_CONTENT_PATH.concat("encryptedClientRequest.json"))
                .getPath();
        return path;
    }

    public static byte[] getKeyFromFile(String fileName) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(
                new InputStreamReader(new FileInputStream(getKeyAsString(fileName)), StandardCharsets.UTF_8))) {
            String line = null;
            while (null != (line = br.readLine())) {
                sb.append(line);
                sb.append("\r\n");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return Base64.encode(sb.toString().getBytes());

    }

    private static String getKeyAsString(String keyFileName) {
        String path = JsonUtil.class.getClassLoader().getResource(keyFileName).getPath();
        return path;
    }

    /**
     * Read json response file.
     *
     * @return mock json data
     */
    public static JSONObject getBankResponseJson() {
        StringBuilder sb = new StringBuilder();
        JSONObject requestJson = null;
        try (BufferedReader br = new BufferedReader(
                new InputStreamReader(new FileInputStream(getBankResponseFile()), StandardCharsets.UTF_8))) {
            String line = null;
            while (null != (line = br.readLine())) {
                sb.append(line);
                sb.append("\r\n");
            }
            requestJson = new JSONObject(sb.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return requestJson;
    }

    public static String getBankResponseFile() {
        String path = JsonUtil.class.getClassLoader().getResource(ProjectResource.RESPONSE_CONTENT_PATH.concat("bankResponsePlain.json"))
                .getPath();
        return path;
    }

    public static String getEncryptedBankResponse() {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(
                new InputStreamReader(new FileInputStream(getEncryptedBankResponseFromFile()), StandardCharsets.UTF_8))) {
            String line = null;
            while (null != (line = br.readLine())) {
                sb.append(line);
                sb.append("\r\n");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();

    }

    private static String getEncryptedBankResponseFromFile() {

        String path = JsonUtil.class.getClassLoader().getResource(ProjectResource.RESPONSE_CONTENT_PATH.concat("bankResponseEncrypted.json"))
                .getPath();
        System.out.println("#5. Reading and converting the following Response File: " + path);
        return path;
    }

}
