package util;

import config.ClientConfig;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;

import static util.JsonUtil.getJsonObjectFromFile;

public class Projects {
    public static JSONObject projectSettings = getJsonObjectFromFile(ClientConfig.RESOURCE_PATH + "projects.json");

    public Projects() {
    }

    public static void main(String[] args) {
        System.out.println(LoadActiveProjectSettings().get("bankPublicKeyFile"));
        System.out.println(LoadActiveProjectSettings().get("targetHost"));
        System.out.println(LoadActiveProjectSettings().get("addSignatureToMessageSigning"));
    }

    public static HashMap<String, String> LoadActiveProjectSettings() {
        HashMap<String, String> activeProjectSettings = new HashMap<String, String>();
        JSONArray projects = null;
        try {
            projects = projectSettings.getJSONArray("projects");

            JSONObject project;
            for (int i = 0; i < projects.length(); i++) {
                project = (JSONObject) projects.get(i);
                if ((boolean) project.get("active") == true) {
                    activeProjectSettings.put("name", project.getString("name"));
                    activeProjectSettings.put("targetHost", project.getString("targetHost"));
                    activeProjectSettings.put("clientHostingRegion", project.getString("clientHostingRegion"));
                    switch (activeProjectSettings.get("targetHost")) {
                        case ("SANDBOX"):
                            activeProjectSettings.put("baseUrl", ClientConfig.BASE_URL.get("SANDBOX"));
                            break;
                        case ("UAT"):
                            activeProjectSettings.put("baseUrl", ClientConfig.BASE_URL.get("UAT"));
                            break;
                        case ("PRODUCTION"):
                            activeProjectSettings.put("baseUrl", ClientConfig.BASE_URL.get("PRODUCTION"));
                            break;
                    }
                    activeProjectSettings.put("clientProfileId", project.getString("clientProfileId"));
                    if (project.has("oboProfileId")) {
                        activeProjectSettings.put("oboProfileId", project.getString("oboProfileId"));
                    } else {
                        activeProjectSettings.put("oboProfileId", null);
                    }
                    if (project.has("clientId")) {
                        activeProjectSettings.put("clientId", project.getString("clientId"));
                    }
                    if (project.has("clientSecret")) {
                        activeProjectSettings.put("clientSecret", project.getString("clientSecret"));
                    }
                    if (project.has("organizationId")) {
                        activeProjectSettings.put("organizationId", project.getString("organizationId"));
                    }
                    JSONObject pgpKeys = (JSONObject) project.get("pgpKeys");
                    JSONObject fileNames = (JSONObject) pgpKeys.get("fileNames");
                    activeProjectSettings.put("bankPublicKeyFile", ClientConfig.KEY_PATH + activeProjectSettings.get("name") + "/" + fileNames.get("bankPublic"));
                    activeProjectSettings.put("clientPublicKeyFile", ClientConfig.KEY_PATH + activeProjectSettings.get("name") + "/" + fileNames.get("clientPublic"));
                    activeProjectSettings.put("clientPrivateKeyFile", ClientConfig.KEY_PATH + activeProjectSettings.get("name") + "/" + fileNames.get("clientPrivate"));
                    activeProjectSettings.put("clientPrivateKeyPassphrase", pgpKeys.get("clientPrivateKeyPassphrase").toString());
                    if (project.has("xHsbcCryptoSignature")) {
                        activeProjectSettings.put("xHsbcCryptoSignature", project.getString("xHsbcCryptoSignature"));
                    } else {
                        activeProjectSettings.put("xHsbcCryptoSignature", "true");
                    }
                    System.out.println("Active Project: " + activeProjectSettings.get("name"));
                    System.out.println("Target Host: " + activeProjectSettings.get("targetHost"));
                    break;
                }

            }

        } catch (JSONException e) {
            e.printStackTrace();

        }
        return activeProjectSettings;
    }
}
